@echo off

REM All variable definitions herein are 'local'
setlocal

echo.
echo      *** FLTK CONFIGURATION ***
echo.

REM ***
REM *** DEBUG/RELEASE
REM ***
    if defined DEBUG goto debug_defined
    :debug_prompt
    set DEBUG=
    set /P DEBUG=     Build Mode: D)ebug or R)elease? [R] 
    IF NOT DEFINED DEBUG set DEBUG=R
    IF %DEBUG%==r set DEBUG=R
    IF %DEBUG%==d set DEBUG=D
    IF %DEBUG%==R goto debug_defined
    IF %DEBUG%==D goto debug_defined
    goto debug_prompt
    :debug_defined

REM ***
REM *** VERBOSE/QUIET
REM ***
    if defined VERBOSE goto verbose_defined
    :verbose_prompt
    set VERBOSE=
    set /P VERBOSE=Build Verbosity: V)erbose or Q)uiet? [Q] 
    IF NOT DEFINED VERBOSE set VERBOSE=Q
    IF %VERBOSE%==v set VERBOSE=V
    IF %VERBOSE%==q set VERBOSE=Q
    IF %VERBOSE%==V goto verbose_defined
    IF %VERBOSE%==Q goto verbose_defined
    goto verbose_prompt
    :verbose_defined

    echo.

REM ***
REM *** INSTALL MAKEFILES
REM ***

    echo === installing makefiles ===
    echo *** TOP
    copy buildtools.windows\Makefiles\Makefile.MICROSOFT        .
    copy buildtools.windows\Makefiles\gmake-vsnet-include       .

    echo *** SRC
    copy buildtools.windows\Makefiles\src\Makefile.MICROSOFT    src
    copy buildtools.windows\Makefiles\src\gmake.bat             src
    copy buildtools.windows\Makefiles\src\gmake-fltk-include    src

    echo *** JPEG
    copy buildtools.windows\Makefiles\jpeg\Makefile.MICROSOFT   jpeg
    copy buildtools.windows\Makefiles\src\gmake.bat             jpeg

    echo *** PNG
    copy buildtools.windows\Makefiles\png\Makefile.MICROSOFT    png
    copy buildtools.windows\Makefiles\src\gmake.bat             png

    echo *** ZLIB
    copy buildtools.windows\Makefiles\zlib\Makefile.MICROSOFT   zlib
    copy buildtools.windows\Makefiles\src\gmake.bat             zlib

    echo *** FLUID
    copy buildtools.windows\Makefiles\fluid\Makefile.MICROSOFT  fluid
    copy buildtools.windows\Makefiles\src\gmake.bat             fluid

    echo *** TEST
    copy buildtools.windows\Makefiles\test\Makefile.MICROSOFT   test
    copy buildtools.windows\Makefiles\src\gmake.bat             test


REM ***
REM *** CREATE CONFIG FILE
REM ***
    echo.
    echo === creating configure files ===
    echo # Created by 'gmake configure' on %DATE% %TIME% > gmake-configure-include
    echo.>>                            gmake-configure-include
    echo # DEBUG>>                     gmake-configure-include
    if %DEBUG%==R echo FLTKDEBUG=0 >>  gmake-configure-include
    if %DEBUG%==D echo FLTKDEBUG=1 >>  gmake-configure-include
    echo.>>                            gmake-configure-include
    echo # VERBOSE>>                   gmake-configure-include
    if %VERBOSE%==V echo # .SILENT:>>  gmake-configure-include
    if %VERBOSE%==Q echo .SILENT:>>    gmake-configure-include
    echo.>>                            gmake-configure-include
    echo # FLTK TOP LEVEL DIR>>        gmake-configure-include
    echo FLTKTOPDIR=%CD%>>             gmake-configure-include

REM ***
REM *** CREATE CONFIG.H FILE
REM ***
    echo.
    echo === creating config.h ===
    echo # Copying from vcnet directory
    copy /Y vcnet\config.h .

REM ***
REM *** MAKE SURE .fl FILES ARE NOT NEWER THAN .cxx
REM ***     Otherwise fluid.exe will be called before the library is built.
REM ***     DOS does not have a 'touch' command, so we use this ugly hack
REM ***     to make the date current without changing the file.
REM ***
type >> src\Fl_File_Chooser.cxx 2> null

REM ***
REM *** DONE
REM ***
    echo.
    echo *** CONFIGURED. You can now rebuild fltk with:
    echo.
    echo         gmake clean
    echo         gmake
    echo.
